#include "common_header.h"
#include "skybox.h"

void CSkybox::loadSkybox(string a_sDirectory, string a_sFront, string a_sBack, string a_sLeft, string a_sRight, string a_sTop, string a_sBottom)
{
	tTextures[0].loadTexture2D(a_sDirectory+a_sFront);
	tTextures[1].loadTexture2D(a_sDirectory+a_sBack);
	tTextures[2].loadTexture2D(a_sDirectory+a_sLeft);
	tTextures[3].loadTexture2D(a_sDirectory+a_sRight);
	tTextures[4].loadTexture2D(a_sDirectory+a_sTop);
	tTextures[5].loadTexture2D(a_sDirectory+a_sBottom);

	sDirectory = a_sDirectory;

	sFront = a_sFront;
	sBack = a_sBack;
	sLeft = a_sLeft;
	sRight = a_sRight;
	sTop = a_sTop;
	sBottom = a_sBottom;

	FOR(i, 6)
	{
		tTextures[i].setFiltering(TEXTURE_FILTER_MAG_BILINEAR, TEXTURE_FILTER_MIN_BILINEAR);
		tTextures[i].setSamplerParameter(GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		tTextures[i].setSamplerParameter(GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	}

	glGenVertexArrays(1, &uiVAO);
	glBindVertexArray(uiVAO);

	vboRenderData.createVBO();
	vboRenderData.bindVBO();

	vec3 vSkyBoxVertices[24] = 
	{
		vec3(50.0f, 50.0f, 50.0f), vec3(50.0f, -50.0f, 50.0f), vec3(-50.0f, 50.0f, 50.0f), vec3(-50.0f, -50.0f, 50.0f),
		vec3(-50.0f, 50.0f, -50.0f), vec3(-50.0f, -50.0f, -50.0f), vec3(50.0f, 50.0f, -50.0f), vec3(50.0f, -50.0f, -50.0f),
		vec3(-50.0f, 50.0f, 50.0f), vec3(-50.0f, -50.0f, 50.0f), vec3(-50.0f, 50.0f, -50.0f), vec3(-50.0f, -50.0f, -50.0f),
		vec3(50.0f, 50.0f, -50.0f), vec3(50.0f, -50.0f, -50.0f), vec3(50.0f, 50.0f, 50.0f), vec3(50.0f, -50.0f, 50.0f),
		vec3(-50.0f, 50.0f, -50.0f), vec3(50.0f, 50.0f, -50.0f), vec3(-50.0f, 50.0f, 50.0f), vec3(50.0f, 50.0f, 50.0f),
		vec3(50.0f, -50.0f, -50.0f), vec3(-50.0f, -50.0f, -50.0f), vec3(50.0f, -50.0f, 50.0f), vec3(-50.0f, -50.0f, 50.0f),
	};

	vec2 vSkyBoxTexCoords[4] =
	{
		vec2(0.0f, 1.0f), vec2(0.0f, 0.0f), vec2(1.0f, 1.0f), vec2(1.0f, 0.0f)
	};

	vec3 vSkyBoxNormals[6] = 
	{
		vec3(0.0f, 0.0f, -1.0f),
		vec3(0.0f, 0.0f, 1.0f),
		vec3(1.0f, 0.0f, 0.0f),
		vec3(-1.0f, 0.0f, 0.0f),
		vec3(0.0f, -1.0f, 0.0f),
		vec3(0.0f, 1.0f, 0.0f)
	};

	FOR(i, 24)
	{
		vboRenderData.addData(&vSkyBoxVertices[i], sizeof(vec3));
		vboRenderData.addData(&vSkyBoxTexCoords[i%4], sizeof(vec2));
		vboRenderData.addData(&vSkyBoxNormals[i/4], sizeof(vec3));
	}

	vboRenderData.uploadDataToGPU(GL_STATIC_DRAW);

	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 2*sizeof(vec3)+sizeof(vec2), 0);
	glEnableVertexAttribArray(1);
	glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, 2*sizeof(vec3)+sizeof(vec2), (void*)sizeof(vec3));
	glEnableVertexAttribArray(2);
	glVertexAttribPointer(2, 3, GL_FLOAT, GL_FALSE, 2*sizeof(vec3)+sizeof(vec2), (void*)(sizeof(vec3)+sizeof(vec2)));
}

void CSkybox::renderSkybox()
{
	glDepthMask(0);
	glBindVertexArray(uiVAO);
	FOR(i, 6)
	{
		tTextures[i].bindTexture();
		glDrawArrays(GL_TRIANGLE_STRIP, i*4, 4);
	}
	glDepthMask(1);
}

void CSkybox::releaseSkybox()
{
	FOR(i, 6)tTextures[i].releaseTexture();
	glDeleteVertexArrays(1, &uiVAO);
	vboRenderData.releaseVBO();
}
